***************************************************************************************************************************************************************************************************************************************************************************
**************  	The purpose of this replication package is to produce the firm-level Global Indicator Database for year 2009 and later using the firm-level cross-country responses data. The replication is automated by running this 1_main.do file.   **************
***************************************************************************************************************************************************************************************************************************************************************************

/************************ USERS: PLEASE READ ***********************************
1. Please change the global_directory to the path of this unzipped replication folder.
2. Please change the global input_new_comprehensive to the file name of the database that was saved to the replication folder.
*****************************************************************************************************************/


*** Last edited by the authors: January 23, 2026     **************
*** This is work in progress. The authors are working to improve the package for the next release
*** The most updated code is available here: https://www.enterprisesurveys.org/en/methodology as part of the Replication of WBES Indicators rubric. 
*** For questions, comments, or suggestions, please contact us at: enterprisesurveys@worldbank.org
*****************************************************************************************************************/

global global_directory = ""
global input_new_comprehensive = "$global_directory\New_Comprehensive_January_22_2026.dta"

*****************************************************************************************************************
**************  	PLEASE DO NOT CHANGE BELOW UNLESS FILE LOCATIONS OR NAMES CHANGED              **************
*****************************************************************************************************************

*****************************************************************************************************************
**************  	                     set basic parameters                                      **************
*****************************************************************************************************************
set varabbrev on
clear 
set memory 900m
set matsize 5000
set more off
version 10
set type double

timer clear
timer on 1
*****************************************************************************************************************
**************  	                     DEFINE FILES                                              **************
*****************************************************************************************************************

global global_inputs_replication = "$global_directory\\input_files"
global global_country_region_income = "$global_inputs_replication\\country-region-income.dta"
global global_country_gni_pop = "$global_inputs_replication\country-groups-gni-pop.dta"
global global_outputs = "$global_directory\\output"
global global_dofiles = "$global_directory\\do_files"

global exchange_rates_WDI_data = "$global_inputs_replication\\Exchange Rates_WDI_LCU_per_USD_Jul2025.dta"
global deflators_WDI_data = "$global_inputs_replication\\GDP_deflators_WDI_Jul2025.dta"

***************************************************************************************************************************************************************************************************************************************************************************
***** run do files
***************************************************************************************************************************************************************************************************************************************************************************

do "$global_dofiles\\2_auxiliaries.do"
do "$global_dofiles\\3.1_final_cleaning.do"
do "$global_dofiles\\3_intermediate.do"
do "$global_dofiles\\4_generate_indicators.do"
do "$global_dofiles\\5_labels_save_data.do"